<form autocomplete="off" method="post" class="fpbx-submit">
    <!-- region BX24_APPLICATION_SECRET -->
    <div class="element-container">
        <div class="row">
            <div class="form-group">
                <div class="col-md-3">
                    <label for="bitrix24-application-secret" class="control-label"><?= _('Bitrix24 Secret') ?></label>
                    <i class="fa fa-question-circle fpbx-help-icon" data-for="bitrix24-application-secret"></i>
                </div>
                <div class="col-md-9">
                    <input name="bx24_application_secret" id="bitrix24-application-secret" class="form-control">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <span id="bitrix24-application-secret-help" class="help-block fpbx-help-block"><?= _('Secret token from your Bitrix24 zruchna.io application window.') ?></span>
            </div>
        </div>
    </div>
    <!-- endregion BX24_APPLICATION_SECRET -->

    <!-- region FREEPBX_BASE_URI -->
    <div class="element-container">
        <div class="row">
            <div class="form-group">
                <div class="col-md-3">
                    <label for="freepbx-base-uri" class="control-label"><?= _('Public FreePBX\'s base URL') ?></label>
                    <i class="fa fa-question-circle fpbx-help-icon" data-for="freepbx-base-uri"></i>
                </div>
                <div class="col-md-9">
                    <input name="freepbx_base_uri" id="freepbx-base-uri" class="form-control"<?php if (!empty($freepbxBaseUrl)): ?> value="<?= htmlentities($freepbxBaseUrl, ENT_COMPAT) ?>"<?php endif ?>>
                </div>
            </div>
        </div>

        <?php if ('failed-public-url' === $error): ?>
            <div class="row">
                <div class="col-md-12">
                    <div id="freepbx-base-uri-error" class="text-danger">
                        <p><?= _('Unable to check public URL availability.') ?></p>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <div class="row">
            <div class="col-md-12">
                <div id="freepbx-base-uri-help" class="help-block fpbx-help-block">
                    <p><?= _('Public base URL of this FreePBX.') ?></p>
                    <p><?= _('Example:') ?> <code>http://123.0.0.12/admin/</code></p>
                </div>
            </div>
        </div>
    </div>
    <!-- endregion FREEPBX_BASE_URI -->

    <!-- region RECORDS_EXTENSION -->
    <div class="element-container">
        <div class="row">
            <div class="form-group">
                <div class="col-md-3">
                    <label for="records-extension" class="control-label"><?= _('Records extension') ?></label>
                    <i class="fa fa-question-circle fpbx-help-icon" data-for="records-extension"></i>
                </div>
                <div class="col-md-9">
                    <select name="records_extension" id="records-extension" class="form-control">
                        <?php foreach (['wav', 'mp3'] as $possibleRecordsExtension): ?>
                            <option<?php if ($possibleRecordsExtension === $recordsExtension): ?> selected<?php endif ?>><?= htmlentities($possibleRecordsExtension, ENT_NOQUOTES) ?></option>
                        <?php endforeach ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <span id="records-extension-help" class="help-block fpbx-help-block"><?= _('Extension of record files.') ?></span>
            </div>
        </div>
    </div>
    <!-- endregion RECORDS_EXTENSION -->

    <!-- region CLIENT_NAME -->
    <div class="element-container">
        <div class="row">
            <div class="form-group">
                <div class="col-md-3">
                    <label for="client-name" class="control-label"><?= _('Client name') ?></label>
                    <i class="fa fa-question-circle fpbx-help-icon" data-for="client-name"></i>
                </div>
                <div class="col-md-9">
                    <input id="client-name" class="form-control"<?php if (!empty($clientName)): ?> value="<?= htmlentities($clientName, ENT_COMPAT) ?>"<?php endif ?> readonly>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <span id="client-name-help" class="help-block fpbx-help-block"><?= _('Name of integration client.') ?></span>
            </div>
        </div>
    </div>
    <!-- endregion CLIENT_NAME -->
</form>
