<?php assert(isset($uploadedRecords) && \is_array($uploadedRecords)) ?>

<?php $localTimezone = static function () {
    static $localTimeZone = null;

    if (null === $localTimeZone) {
        $localTimeZone = new DateTimeZone('Europe/Minsk');
    }

    return $localTimeZone;
} ?>

<?php $dateFormatter = static function ($date) use ($localTimezone) {
    if (null === $date) {
        return null;
    }
    if (!$date instanceof DateTimeInterface) {
        throw new InvalidArgumentException(sprintf('Expected to $date be %s, %s provided', DateTimeInterface::class, is_object($date) ? get_class($date) : gettype($date)));
    }

    if (!$date instanceof DateTimeImmutable) {
        $date = clone $date;
    }

    if (method_exists($date, 'setTimezone')) {
        $date = $date->setTimezone($localTimezone());
    }

    return $date->format('d.m.Y H:i:s');
} ?>

<?php $recordingLinkMixin = static function ($recording, $nullValueLabel = 'not set') { ?>
    <?php ob_start() ?>
    <?php try { ?>
        <?php if (null === $recording): ?>
            <i class="small"><?= htmlspecialchars($nullValueLabel, ENT_HTML5 | ENT_NOQUOTES) ?></i>
            <?php return ?>
        <?php endif ?>

        <?php if (!$recording instanceof Zruchna\FreePbx\RecordsUploader\Entity\Recording): ?>
            <?php throw new InvalidArgumentException(sprintf('Expected to $recording be %s, %s provided', Zruchna\FreePbx\RecordsUploader\Entity\Recording::class, is_object($recording) ? get_class($recording) : gettype($recording))) ?>
        <?php endif ?>

        <?php $recordingUrl = sprintf('?display=recordings&action=edit&id=%d', $recording->getId()) ?>
        <?php $recordingLabel = sprintf('#%d %s', $recording->getId(), $recording->getDisplayName()) ?>

        <a href="<?= htmlspecialchars($recordingUrl, ENT_HTML5 | ENT_COMPAT) ?>" target="_blank">
            <?= htmlspecialchars($recordingLabel, ENT_HTML5 | ENT_NOQUOTES) ?>
        </a>
    <?php } finally { ?>
        <?php return ob_get_clean() ?>
    <?php } // endfinally ?>
<?php } // endfunction ?>

<?php $optionalDateMixin = static function ($date, $nullValueLabel = 'not set') use ($dateFormatter) { ?>
    <?php ob_start() ?>
    <?php try { ?>
        <?php if (null === $date): ?>
            <i class="small"><?= htmlspecialchars($nullValueLabel, ENT_HTML5 | ENT_NOQUOTES) ?></i>
            <?php return ?>
        <?php endif ?>

        <?php if (!$date instanceof DateTimeInterface): ?>
            <?php throw new InvalidArgumentException(sprintf('Expected to $recording be %s, %s provided', DateTimeInterface::class, is_object($date) ? get_class($date) : gettype($date))) ?>
        <?php endif ?>

        <?= htmlspecialchars($dateFormatter($date), ENT_HTML5 | ENT_NOQUOTES) ?>
    <?php } finally { ?>
        <?php return ob_get_clean() ?>
    <?php } // endfinally ?>
<?php } // endfunction ?>

<div class="bootstrap-table">
    <div class="fixed-table-container">
        <div class="fixed-table-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th><?= _('Filename') ?></th>
                        <th><?= _('System Recording') ?></th>
                        <th><?= _('Queued date') ?></th>
                        <th><?= _('Uploaded date') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($uploadedRecords as $uploadedRecord): ?>
                        <?php assert($uploadedRecord instanceof Zruchna\FreePbx\RecordsUploader\Entity\UploadingItem) ?>

                        <tr>
                            <td><?= htmlspecialchars($uploadedRecord->getFilename(), ENT_HTML5 | ENT_NOQUOTES) ?></td>
                            <td><?= $recordingLinkMixin($uploadedRecord->getRecording()) ?></td>
                            <td><?= htmlspecialchars($dateFormatter($uploadedRecord->getQueuedAt()), ENT_HTML5 | ENT_NOQUOTES) ?></td>
                            <td><?= $optionalDateMixin($uploadedRecord->getUploadedAt(), 'not uploaded') ?></td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
