<?php

namespace Zruchna\FreePbx\RecordsUploader\Repository;

use Doctrine\ORM\EntityManager;
use Zruchna\FreePbx\RecordsUploader\Doctrine\DBAL\Type\DatetimeImmutableUtcType;
use Zruchna\FreePbx\RecordsUploader\Entity\UploadingItem;

/**
 * @method UploadingItem|null find($id, $lockMode = null, $lockVersion = null)
 * @method UploadingItem[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 * @method UploadingItem|null findOneBy(array $criteria, array $orderBy = null)
 * @method UploadingItem[]    findAll()
 */
class UploadingItemRepository extends AbstractSimpleRepository
{
    public function __construct(EntityManager $em)
    {
        parent::__construct($em, UploadingItem::class);
    }

    /**
     * @param int $limit
     * @return UploadingItem[]
     */
    public function findPending(\DateTimeImmutable $atTime, $limit = 10)
    {
        $rangeStart = $atTime->modify('1 week ago');

        return $this->createQueryBuilder('u')
            ->andWhere('u.queuedAt BETWEEN :range_start AND :range_end')
            ->setParameter('range_start', $rangeStart, DatetimeImmutableUtcType::DATETIME_IMMUTABLE_UTC)
            ->setParameter('range_end', $atTime, DatetimeImmutableUtcType::DATETIME_IMMUTABLE_UTC)
            ->andWhere('u.uploadedAt IS NULL')
            ->orderBy('u.id', 'ASC')
            ->setMaxResults($limit)
            ->getQuery()
            ->getResult();
    }
}
