<?php

namespace Zruchna\FreePbx\RecordsUploader\Factory;

use Symfony\Component\Console\Application;
use Symfony\Component\Console\CommandLoader\CommandLoaderInterface;
use Symfony\Component\Console\CommandLoader\FactoryCommandLoader;
use Zruchna\FreePbx\RecordsUploader\Command\UploadRecordsCommand;

abstract class TinyConsoleApplicationFactory
{
    /** @var Application|null */
    private static $application = null;

    /**
     * @return Application
     */
    public static function getConsoleApplication()
    {
        if (null !== self::$application) {
            return self::$application;
        }

        self::$application = $application = new Application('zruchna-records-uploader');

        $application->setCommandLoader(self::getCommandLoader());

        return $application;
    }

    /**
     * @return CommandLoaderInterface
     */
    protected static function getCommandLoader()
    {
        return new FactoryCommandLoader(array(
            'upload-records' => function () {
                return new UploadRecordsCommand();
            },
        ));
    }
}
