<?php

namespace Zruchna\FreePbx\RecordsUploader\Factory\Repository;

use Doctrine\DBAL\DBALException;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\ORMException;
use Zruchna\FreePbx\RecordsUploader\Factory\Doctrine\EntityManagerFactory;
use Zruchna\FreePbx\RecordsUploader\Repository\AbstractSimpleRepository;

abstract class SimpleRepositoryFactory
{
    /** @var array<string, AbstractSimpleRepository> */
    private static $repositoryRegistry = array();

    /**
     * @return AbstractSimpleRepository
     * @throws ORMException
     * @throws DBALException
     */
    public static function getRepository($entityClass)
    {
        if (isset(self::$repositoryRegistry[$entityClass])) {
            return self::$repositoryRegistry[$entityClass];
        }

        $entityManager = self::getEntityManager();
        $entityMetadata = $entityManager->getClassMetadata($entityClass);
        $repositoryClass = $entityMetadata->customRepositoryClassName;

        if (!\in_array(AbstractSimpleRepository::class, \class_parents($repositoryClass), true)) {
            throw new \InvalidArgumentException('Expected entity with simple repository');
        }

        return self::$repositoryRegistry[$entityClass] = new $repositoryClass($entityManager);
    }

    /**
     * @throws DBALException
     * @throws ORMException
     * @return EntityManagerInterface
     */
    protected static function getEntityManager()
    {
        return EntityManagerFactory::getEntityManager();
    }
}
