<?php

namespace Zruchna\FreePbx\RecordsUploader\Factory\Doctrine;

use Doctrine\Common\EventManager;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Driver;
use Doctrine\DBAL\Types\Type;
use FreePBX\Database;
use Zruchna\FreePbx\RecordsUploader\Doctrine\DBAL\Type\DatetimeImmutableUtcType;

abstract class ConnectionFactory
{
    /** @var Connection|null */
    private static $connection = null;

    private static $registerTypes = array(
        DatetimeImmutableUtcType::DATETIME_IMMUTABLE_UTC => DatetimeImmutableUtcType::class,
    );

    /**
     * @throws DBALException
     * @return Connection
     */
    public static function getConnection()
    {
        if (null !== self::$connection) {
            return self::$connection;
        }

        foreach (self::$registerTypes as $typeName => $typeClass) {
            if (!Type::hasType($typeName)) {
                Type::addType($typeName, $typeClass);
            }
        }

        return self::$connection = new Connection(
            self::getParams(),
            self::getDriver(),
            null,
            self::getEventManager()
        );
    }

    /**
     * @return array{ pdo: \PDO }
     */
    protected static function getParams()
    {
        return array(
            'pdo' => self::getPdo(),
        );
    }

    /**
     * @return \PDO
     */
    protected static function getPdo()
    {
        $database = \FreePBX::Database();
        \assert($database instanceof Database);
        \assert($database instanceof \PDO);

        return $database;
    }

    /**
     * @return Driver
     */
    protected static function getDriver()
    {
        return new Driver\PDOMySql\Driver();
    }

    /**
     * @return EventManager
     */
    protected static function getEventManager()
    {
        return EventManagerFactory::getEventManager();
    }
}
