<?php

namespace Zruchna\FreePbx\RecordsUploader\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\RecordsUploader\Repository\UploadingItemRepository;

/**
 * @ORM\Entity(repositoryClass=UploadingItemRepository::class)
 * @ORM\Table(name="zruchna_records_uploading_queue")
 */
class UploadingItem
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\Column(name="filename", type="string", length=80, nullable=false)
     *
     * @var string|null
     */
    private $filename = null;

    /**
     * @ORM\ManyToOne(targetEntity=Recording::class)
     * @ORM\JoinColumn(name="recording_id", nullable=true)
     *
     * @var Recording|null
     */
    private $recording = null;

    /**
     * @ORM\Column(name="url", type="string", length=255, nullable=false)
     *
     * @var string|null
     */
    private $url = null;

    /**
     * @ORM\Column(name="queued_at", type="datetime_immutable_utc", nullable=false)
     *
     * @var \DateTimeImmutable|null
     */
    private $queuedAt = null;

    /**
     * @ORM\Column(name="uploaded_at", type="datetime_immutable_utc", nullable=true)
     *
     * @var \DateTimeImmutable|null
     */
    private $uploadedAt = null;

    /**
     * @ORM\Column(name="converted_at", type="datetime_immutable_utc", nullable=true)
     *
     * @var \DateTimeImmutable|null
     */
    private $convertedAt = null;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * @param string|null $filename
     * @return self
     */
    public function setFilename($filename)
    {
        $this->filename = $filename;

        return $this;
    }

    /**
     * @return Recording|null
     */
    public function getRecording()
    {
        return $this->recording;
    }

    /**
     * @param Recording|null $recording
     * @return self
     */
    public function setRecording($recording)
    {
        $this->recording = $recording;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string|null $url
     * @return self
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getQueuedAt()
    {
        return $this->queuedAt;
    }

    /**
     * @param \DateTimeImmutable|null $queuedAt
     * @return self
     */
    public function setQueuedAt($queuedAt)
    {
        $this->queuedAt = $queuedAt;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getUploadedAt()
    {
        return $this->uploadedAt;
    }

    /**
     * @param \DateTimeImmutable|null $uploadedAt
     * @return self
     */
    public function setUploadedAt($uploadedAt)
    {
        $this->uploadedAt = $uploadedAt;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getConvertedAt()
    {
        return $this->convertedAt;
    }

    /**
     * @param \DateTimeImmutable|null $convertedAt
     * @return self
     */
    public function setConvertedAt($convertedAt)
    {
        $this->convertedAt = $convertedAt;

        return $this;
    }
}
