<?php

namespace Zruchna\FreePbx\RecordsUploader\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\RecordsUploader\Repository\RecordingRepository;

/**
 * @ORM\Entity(repositoryClass=RecordingRepository::class)
 * @ORM\Table(name="recordings")
 */
class Recording
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\Column(name="displayname", type="string", length=50, nullable=true)
     *
     * @var string|null
     */
    private $displayName = null;

    /**
     * @ORM\Column(name="filename", type="text", nullable=true)
     *
     * @var string|null
     */
    private $filename = null;

    /**
     * @ORM\Column(name="description", type="string", length=254)
     *
     * @var string|null
     */
    private $description = null;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }

    /**
     * @param string|null $displayName
     * @return self
     */
    public function setDisplayName($displayName)
    {
        $this->displayName = $displayName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * @param string|null $filename
     * @return self
     */
    public function setFilename($filename)
    {
        $this->filename = $filename;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return self
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }
}
