<?php

namespace Zruchna\FreePbx\RecordsUploader\Clock;

class SystemClock implements ClockInterface
{
    /** @var \DateTimeZone */
    private $timezone;

    public function __construct(\DateTimeZone $timezone)
    {
        $this->timezone = $timezone;
    }

    /**
     * @return self
     */
    public static function utc()
    {
        return new self(new \DateTimeZone('UTC'));
    }

    /**
     * {@inheritDoc}
     */
    public function now()
    {
        if (PHP_VERSION_ID >= 70100) {
            return new \DateTimeImmutable('now', $this->timezone);
        }

        $microtime = strtr(sprintf('%.06f', microtime(true)), ',', '.');
        $date = \DateTimeImmutable::createFromFormat('U.u', $microtime, $this->timezone);

        if (false === $date) {
            throw new \LogicException('Unable to parse date from unixtimestamp');
        }

        return $date;
    }
}
