<?php

namespace FreePBX\Modules;

use Composer\Autoload\ClassLoader;
use FreePBX\Job;
use FreePBX\modules\Records_uploader\UploadQueuedRecordsJob;
use Zruchna\FreePbx\RecordsUploader\Entity\UploadingItem;
use Zruchna\FreePbx\RecordsUploader\Factory\Repository\SimpleRepositoryFactory;
use Zruchna\FreePbx\RecordsUploader\Repository\UploadingItemRepository;

class Records_uploader extends \FreePBX_Helpers implements \BMO
{
    /** @var \FreePBX $FreePBX */
    protected $FreePBX;

    /** @var Job */
    private $jobManagement;

    /** @var ClassLoader */
    private $autoloader;

    /**
     * @param \FreePBX $freepbx
     * @throws \Exception
     * @throws \BadMethodCallException
     */
    public function __construct($freepbx = null)
    {
        parent::__construct($freepbx);

        if (null === $freepbx) {
            throw new \BadMethodCallException('Not given a FreePBX Object');
        }

        $this->FreePBX = $freepbx;
        $this->jobManagement = $freepbx->Job;

        $this->autoloader = require __DIR__.'/src/bootstrap.php';
    }

    public function install()
    {
        $this->jobManagement->addClass(
            'records_uploader',
            'upload-queued-records',
            UploadQueuedRecordsJob::class,
            '* * * * *'
        );
    }

    public function uninstall()
    {
        $this->jobManagement->removeAllByModule('records_uploader');
    }

    public function backup()
    {
        // TODO: Implement backup() method.
    }

    public function restore($backup)
    {
        // TODO: Implement restore() method.
    }

    public function doConfigPageInit($page)
    {
    }

    public function getActionBar($request)
    {
        $buttons = array();
        switch ($_GET['display']) {
            case 'records_uploader':
                $buttons = array(
                    'delete' => array(
                        'name' => 'delete',
                        'id' => 'delete',
                        'value' => _('Delete')
                    ),
                    'reset' => array(
                        'name' => 'reset',
                        'id' => 'reset',
                        'value' => _('Reset')
                    ),
                    'submit' => array(
                        'name' => 'submit',
                        'id' => 'submit',
                        'value' => _('Submit')
                    )
                );
                if (empty($_GET['extdisplay'])) {
                    unset($buttons['delete']);
                }
                break;
        }
        return $buttons;
    }

    public function showPage()
    {
        $view = empty($_REQUEST['view']) ? 'main' : $_REQUEST['view'];

        if ('POST' === $_SERVER['REQUEST_METHOD']) {
            $_SERVER['REQUEST_URI'] = preg_replace(
                ['~error(?:=[^&#]*)?~', '~&{2,}~'],
                '&',
                $_SERVER['REQUEST_URI']
            );

            // \needreload();

            header('Location: '.$_SERVER['REQUEST_URI'], true, 302);
            return '';
        }

        $uploadedRecords = $this->findRecentUploadingItems();

        return load_view(__DIR__ . '/views/main.php', [
            'uploadedRecords' => $uploadedRecords,
        ]);
    }

    /**
     * @param string $req
     * @param array $setting
     * @return bool
     *
     * @noinspection PhpUnused
     */
    public function ajaxRequest($req, &$setting)
    {
        switch ($req) {
            case 'ping':
                $this->allowAnonymous($setting);

                return true;
            default:
                return false;
        }
    }

    public function ajaxHandler()
    {
        switch ($_REQUEST['command']) {
            case 'ping':
                return 'pong';
            default:
                return false;
        }
    }

    public function getRightNav($request)
    {
        return '';

        return <<<'HTML'
<div class="bootstrap-table">
  <div class="fixed-table-toolbar">
    <div class="bs-bars">
      <div class="toolbar-cbbnav">
        <a href="?display=records_uploader" class="btn btn-default">Main</a>
      </div>
    </div>
  </div>
</div>
HTML;
    }

    /**
     * @return UploadingItem[]
     */
    protected function findRecentUploadingItems()
    {
        $repository = $this->getUploadingItemRepository();

        return $repository->findBy(array(), array('queuedAt' => 'DESC'), 20);
    }

    /**
     * @return void
     */
    private function allowAnonymous(array &$setting)
    {
        $setting['allowremote'] = true;
        $setting['authenticate'] = false;
    }

    /**
     * @return UploadingItemRepository
     */
    private function getUploadingItemRepository()
    {
        return SimpleRepositoryFactory::getRepository(UploadingItem::class);
    }
}
