#!/bin/bash

SECRET=$(echo -n "$8:$(date +%Y-%m-%d)" | md5sum | cut -d' ' -f 1)
SECRET=$(echo -n "$7:$SECRET" | base64)

echo "[INFO] Calculated secret: $SECRET" >&2

curl ${CURL_OPTIONS:-} --get \
	--user-agent "zruchna.io Calltracking ${MODULE_VERSION}" \
	--data-urlencode "secret=$SECRET" \
	--data-urlencode 'v=1' \
	--data-urlencode "peer_number=$1" \
	--data-urlencode "peer_status=$6" \
	--data-urlencode "operator_number=$2" \
	--data-urlencode "operator_status=$6" \
	--data-urlencode "call_id=$3" \
	--data-urlencode "call_duration=$4" \
	--data-urlencode "originate_number=$5" \
	--data-urlencode 'originate_status=ANSWER' \
	--data-urlencode "account=$9" \
	'https://web.it-center.by/ajax/ats_retrieve_call_status'
