<?php

namespace Zruchna\FreePbx\Autorecaller\Service;

use Zruchna\FreePbx\Autorecaller\Contract\Originator;

class CallfileOriginator implements Originator
{
    protected $template = <<<'CALLFILE'
Channel: Local/{rule_id}@missdialoperators
Callerid: {caller_id} <{caller_id}>
Set: abon={caller_id}
Set: ZRUCHNA_RECALL_ID={recall_id}
Set: ZRUCHNA_RECALL_RULE_ID={rule_id}
MaxRetries: 0
RetryTime: 300
WaitTime: 200
Account: {account_code}
Context: misscallavto
Extension: {rule_id}
Priority: 1
Archive: Yes
CALLFILE;

    /**
     * {@inheritDoc}
     */
    public function originateCall($callerId, $recallerId, $ruleId, $recallId)
    {
        $accountCode = uniqid('MS');

        $callfile = strtr($this->template, array(
            '{caller_id}' => $callerId,
            '{recaller_id}' => sprintf('%d', $recallerId),
            '{rule_id}' => sprintf('%d', $ruleId),
            '{recall_id}' => sprintf('%d', $recallId),
            '{account_code}' => $accountCode,
        ));

        $filename = sprintf('/var/spool/asterisk/outgoing/%s.call', $accountCode);

        if (file_exists($filename)) {
            throw new \UnexpectedValueException('Callfile with same name already exists');
        }
        if (false === file_put_contents($filename, $callfile, LOCK_EX)) {
            throw new \RuntimeException('Unable to create callfile');
        }

        return $accountCode;
    }
}
