<?php

namespace Zruchna\FreePbx\Autorecaller\Repository;

use Doctrine\DBAL\Types\Type;
use Doctrine\ORM\EntityManagerInterface;
use Zruchna\FreePbx\Autorecaller\Entity\Autorecaller;

/**
 * @method Autorecaller|null find($id, $lockMode = null, $lockVersion = null)
 * @method Autorecaller[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 * @method Autorecaller|null findOneBy(array $criteria, array $orderBy = null)
 * @method Autorecaller[]    findAll()
 */
class AutorecallerRepository extends AbstractSimpleRepository
{
    public function __construct(EntityManagerInterface $em)
    {
        parent::__construct($em, Autorecaller::class);
    }

    /**
     * @param string $did
     * @param bool|null $enabled
     * @return Autorecaller[]
     */
    public function findByDid($did, $enabled = null)
    {
        $qb = $this->createQueryBuilder('autorecaller')
            ->join('autorecaller.allowedDids', 'allowedDid')
            ->andWhere('allowedDid.did = :fromDid')
            ->setParameter('fromDid', $did, Type::STRING)
        ;

        if (null !== $enabled) {
            $qb
                ->andWhere('autorecaller.enabled = :enabled')
                ->setParameter('enabled', $enabled, Type::BOOLEAN)
            ;
        }

        return $qb->getQuery()->getResult();
    }

    /**
     * @param bool|null $enabled
     * @return Autorecaller[]
     */
    public function findWithoutDid($enabled = null)
    {
        $qb = $this->createQueryBuilder('autorecaller')
            ->leftJoin('autorecaller.allowedDids', 'allowedDid')
            ->andWhere('allowedDid.autorecaller IS NULL')
        ;

        if (null !== $enabled) {
            $qb
                ->andWhere('autorecaller.enabled = :enabled')
                ->setParameter('enabled', $enabled, Type::BOOLEAN)
            ;
        }

        return $qb->getQuery()->getResult();
    }
}
