<?php

namespace Zruchna\FreePbx\Autorecaller\Factory\Dialplan;

use Doctrine\DBAL\DBALException;
use Doctrine\ORM\ORMException;
use Zruchna\FreePbx\Autorecaller\Dialplan\DialplanBuilder;
use Zruchna\FreePbx\Autorecaller\Entity\AutorecallerRule;
use Zruchna\FreePbx\Autorecaller\Factory\Repository\SimpleRepositoryFactory;
use Zruchna\FreePbx\Autorecaller\Repository\AutorecallerRuleRepository;

abstract class DialplanBuilderFactory
{
    public static function getDialplanBuilder()
    {
        $autorecallerRuleRepository = self::getAutorecallerRuleRepository();

        return new DialplanBuilder($autorecallerRuleRepository);
    }

    /**
     * @throws DBALException
     * @throws ORMException
     * @return AutorecallerRuleRepository
     */
    protected static function getAutorecallerRuleRepository()
    {
        return SimpleRepositoryFactory::getRepository(AutorecallerRule::class);
    }
}
