<?php

namespace Zruchna\FreePbx\Autorecaller\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autorecaller\Repository\ScheduledRecallRepository;

/**
 * @ORM\Entity(repositoryClass=ScheduledRecallRepository::class)
 * @ORM\Table(name="zruchna_autorecaller_scheduled_recalls")
 */
class ScheduledRecall
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\ManyToOne(targetEntity=AutorecallerRule::class)
     * @ORM\JoinColumn(name="autorecaller_rule_id", nullable=false)
     *
     * @var AutorecallerRule|null
     */
    private $autorecallerRule = null;

    /**
     * @ORM\Column(name="call_id", type="string", length=80, nullable=true)
     *
     * @var string|null
     */
    private $callId = null;

    /**
     * In UTC.
     *
     * @ORM\Column(name="calldate", type="datetime_immutable_utc", nullable=false)
     *
     * @var \DateTimeImmutable|null
     */
    private $calldate = null;

    /**
     * @ORM\Column(name="clid", type="string", length=80, nullable=false)
     *
     * @var string|null
     */
    private $callerId = null;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return AutorecallerRule|null
     */
    public function getAutorecallerRule()
    {
        return $this->autorecallerRule;
    }

    /**
     * @param AutorecallerRule|null $autorecallerRule
     * @return self
     */
    public function setAutorecallerRule($autorecallerRule)
    {
        $this->autorecallerRule = $autorecallerRule;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getCallId()
    {
        return $this->callId;
    }

    /**
     * @param string|null $callId
     * @return self
     */
    public function setCallId($callId)
    {
        $this->callId = $callId;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getCalldate()
    {
        return $this->calldate;
    }

    /**
     * @param \DateTimeImmutable|null $calldate
     * @return self
     */
    public function setCalldate($calldate)
    {
        $this->calldate = $calldate;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getCallerId()
    {
        return $this->callerId;
    }

    /**
     * @param string|null $callerId
     * @return self
     */
    public function setCallerId($callerId)
    {
        $this->callerId = $callerId;

        return $this;
    }
}
