<?php

namespace Zruchna\FreePbx\Autorecaller\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autorecaller\Repository\AutorecallerRuleRepository;

/**
 * @ORM\Entity(repositoryClass=AutorecallerRuleRepository::class)
 * @ORM\Table(name="zruchna_autorecaller_rules")
 */
class AutorecallerRule
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\ManyToOne(targetEntity=Autorecaller::class, inversedBy="rules")
     * @ORM\JoinColumn(name="autorecaller_id", nullable=false)
     *
     * @var Autorecaller|null
     */
    private $autorecaller = null;

    /**
     * @ORM\Column(name="name", type="string", length=80, nullable=false)
     *
     * @var string|null
     */
    private $name = null;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     *
     * @var string|null
     */
    private $description = null;

    /**
     * @ORM\Column(name="priority", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $priority = null;

    /**
     * @ORM\Column(name="delay", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $delay = null;

    /**
     * @ORM\Column(name="timecondition_id", type="integer", nullable=true)
     *
     * @var int|null
     */
    private $timeconditionId = null;

    /**
     * @ORM\ManyToOne(targetEntity=Recording::class)
     * @ORM\JoinColumn(name="recording_id", nullable=true)
     *
     * @var Recording|null
     */
    private $recording = null;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return Autorecaller|null
     */
    public function getAutorecaller()
    {
        return $this->autorecaller;
    }

    /**
     * @param Autorecaller|null $autorecaller
     * @return self
     */
    public function setAutorecaller($autorecaller)
    {
        $this->autorecaller = $autorecaller;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return self
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @param int|null $priority
     * @return self
     */
    public function setPriority($priority)
    {
        $this->priority = $priority;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getDelay()
    {
        return $this->delay;
    }

    /**
     * @param int|null $delay
     * @return self
     */
    public function setDelay($delay)
    {
        $this->delay = $delay;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getTimeconditionId()
    {
        return $this->timeconditionId;
    }

    /**
     * @param int|null $timeconditionId
     * @return self
     */
    public function setTimeconditionId($timeconditionId)
    {
        $this->timeconditionId = $timeconditionId;

        return $this;
    }

    /**
     * @return Recording|null
     */
    public function getRecording()
    {
        return $this->recording;
    }

    /**
     * @param Recording|null $recording
     * @return self
     */
    public function setRecording($recording)
    {
        $this->recording = $recording;

        return $this;
    }
}
