<?php

namespace Zruchna\FreePbx\Autorecaller\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autorecaller\Repository\AllowedDidRepository;

/**
 * @ORM\Entity(repositoryClass=AllowedDidRepository::class)
 * @ORM\Table(name="zruchna_autorecaller_allowed_dids")
 */
class AllowedDid
{
    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity=Autorecaller::class, inversedBy="allowedDids")
     *
     * @var Autorecaller|null
     */
    private $autorecaller = null;

    /**
     * @ORM\Id
     * @ORM\Column(name="did", type="string", length=80, nullable=false)
     *
     * @var string|null
     */
    private $did = null;

    /**
     * @return Autorecaller|null
     */
    public function getAutorecaller()
    {
        return $this->autorecaller;
    }

    /**
     * @param Autorecaller|null $autorecaller
     * @return self
     */
    public function setAutorecaller($autorecaller)
    {
        $this->autorecaller = $autorecaller;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDid()
    {
        return $this->did;
    }

    /**
     * @param string|null $did
     * @return self
     */
    public function setDid($did)
    {
        $this->did = $did;

        return $this;
    }
}
