<?php

namespace Zruchna\FreePbx\Autorecaller\Dialplan;

class ExecIfExtension extends \ext_execif
{
    /** @var bool|null */
    protected static $prependFastAGI = null;

    /**
     * @param string $expr
     * @param \extension $commandIfTrue
     * @param \extension|null $commandIfFalse
     */
    public function __construct($expr, \extension $commandIfTrue, $commandIfFalse = null)
    {
        $trueParsed = $this->parseCommandOutput($commandIfTrue);

        if (null === $commandIfFalse) {
            parent::__construct($expr, $trueParsed['application'], $trueParsed['data']);

            return;
        }

        $falseParsed = $this->parseCommandOutput($commandIfFalse);

        parent::__construct(
            $expr,
            $trueParsed['application'],
            $trueParsed['data'],
            $falseParsed['application'],
            $falseParsed['data']
        );
    }

    /**
     * @param \extension $command
     * @return array{ application: string, data: string }
     */
    private function parseCommandOutput(\extension $command)
    {
        if ($command instanceof DialplanCommandInterface) {
            return array(
                'application' => $command->getApplication(),
                'data' => $command->getData(),
            );
        }

        if (!preg_match('~^(?<application>[^(]+)\((?<data>.+)$~', $command->output(), $matches)) {
            throw new \UnexpectedValueException(sprintf('Unable to parse "%s" dialplan command', $command->output()));
        }

        return $matches;
    }
}
