<?php

namespace Zruchna\FreePbx\Autorecaller\Builder;

use Zruchna\FreePbx\Autorecaller\Clock\ClockInterface;
use Zruchna\FreePbx\Autorecaller\Entity\AutorecallerRule;
use Zruchna\FreePbx\Autorecaller\Entity\ScheduledRecall;

class ScheduledRecallBuilder
{
    /** @var string|null */
    private $callerId = null;

    /** @var AutorecallerRule|null */
    private $rule = null;

    /** @var ClockInterface */
    private $clock;

    public function __construct(ClockInterface $clock)
    {
        $this->clock = $clock;
    }

    /**
     * @return self
     */
    public function reset()
    {
        $this->callerId = null;
        $this->rule = null;

        return $this;
    }

    /**
     * @param string $callerId
     * @return self
     */
    public function setCallerId($callerId)
    {
        $this->callerId = $callerId;

        return $this;
    }

    /**
     * @return self
     */
    public function setRule(AutorecallerRule $rule)
    {
        $this->rule = $rule;

        return $this;
    }

    /**
     * @return ScheduledRecall
     */
    public function getScheduledRecall()
    {
        if (null === $this->callerId) {
            throw new \BadMethodCallException('Caller ID must be set before');
        }
        if (null === $this->rule) {
            throw new \BadMethodCallException('Autorecaller rule must be set before');
        }
        if (null === $ruleDelay = $this->rule->getDelay()) {
            throw new \UnexpectedValueException('Delay field of autorecaller rule must by set');
        }
        try {
            $scheduleInterval = new \DateInterval(sprintf('PT%dS', $ruleDelay));
        } catch (\Exception $e) {
            throw new \UnexpectedValueException('Unable to create schedule interval: '.$e->getMessage(), 0, $e);
        }

        $scheduledDate = $this->clock->now()
            ->add($scheduleInterval)
        ;

        $entity = new ScheduledRecall();
        $entity->setAutorecallerRule($this->rule);
        $entity->setCallerId($this->callerId);
        $entity->setCalldate($scheduledDate);

        return $entity;
    }
}
