<?php

namespace Zruchna\FreePbx\Autorecaller\Repository;

use Doctrine\DBAL\Types\Type;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Zruchna\FreePbx\Autorecaller\Entity\Autorecaller;
use Zruchna\FreePbx\Autorecaller\Entity\AutorecallerRule;

/**
 * @method AutorecallerRule|null find($id, $lockMode = null, $lockVersion = null)
 * @method AutorecallerRule[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 * @method AutorecallerRule|null findOneBy(array $criteria, array $orderBy = null)
 * @method AutorecallerRule[]    findAll()
 */
class AutorecallerRuleRepository extends AbstractSimpleRepository
{
    public function __construct(EntityManagerInterface $em)
    {
        parent::__construct($em, AutorecallerRule::class);
    }

    /**
     * @param int $previousPriority
     * @return AutorecallerRule|null
     */
    public function findNextRule(Autorecaller $autorecaller, $previousPriority)
    {
        $query = $this->createQueryBuilder('r')
            ->andWhere('r.autorecaller = :autorecaller')
            ->setParameter('autorecaller', $autorecaller)
            ->andWhere('r.priority > :prevPriority')
            ->setParameter('prevPriority', $previousPriority, Type::INTEGER)
            ->orderBy('r.priority', 'ASC')
            ->setMaxResults(1)
            ->getQuery();

        try {
            return $query->getSingleResult();
        } catch (NoResultException $e) {
            return null;
        } catch (NonUniqueResultException $e) {
            throw new \LogicException('Result must be always single');
        }
    }
}
