<?php

namespace Zruchna\FreePbx\Autorecaller\Factory;

use Symfony\Component\Console\Application;
use Symfony\Component\Console\CommandLoader\CommandLoaderInterface;
use Symfony\Component\Console\CommandLoader\FactoryCommandLoader;
use Zruchna\FreePbx\Autorecaller\Command\CancelRecallCommand;
use Zruchna\FreePbx\Autorecaller\Command\RegisterMissedCallCommand;
use Zruchna\FreePbx\Autorecaller\Command\RegisterSuccessfulRecallCommand;
use Zruchna\FreePbx\Autorecaller\Command\RegisterUnsuccessfulAttemptCommand;
use Zruchna\FreePbx\Autorecaller\Command\RescheduleRecallCommand;

abstract class TinyConsoleApplicationFactory
{
    /** @var Application|null */
    private static $application = null;

    /**
     * @return Application
     */
    public static function getConsoleApplication()
    {
        if (null !== self::$application) {
            return self::$application;
        }

        self::$application = $application = new Application('zruchna-autorecaller');

        $application->setCommandLoader(self::getCommandLoader());

        return $application;
    }

    /**
     * @return CommandLoaderInterface
     */
    protected static function getCommandLoader()
    {
        return new FactoryCommandLoader(array(
            'cancel-recall' => function () {
                return new CancelRecallCommand();
            },
            'register-missed-call' => function () {
                return new RegisterMissedCallCommand();
            },
            'register-successful-recall' => function () {
                return new RegisterSuccessfulRecallCommand();
            },
            'register-unsuccessful-attempt' => function () {
                return new RegisterUnsuccessfulAttemptCommand();
            },
            'reschedule-recall' => function () {
                return new RescheduleRecallCommand();
            },
        ));
    }
}
