<?php

namespace Zruchna\FreePbx\Autorecaller\Factory\Doctrine;

use Doctrine\Common\Cache\Cache;
use Doctrine\Common\Cache\VoidCache;
use Doctrine\Common\EventManager;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DBALException;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\ORMException;
use Doctrine\ORM\Tools\Setup;

abstract class EntityManagerFactory
{
    /** @var EntityManagerInterface|null */
    private static $entityManager = null;

    /**
     * @throws DBALException
     * @throws ORMException
     * @return EntityManagerInterface
     */
    public static function getEntityManager($env = 'prod')
    {
        if (null !== self::$entityManager) {
            return self::$entityManager;
        }

        return self::$entityManager = EntityManager::create(
            self::getConnection(),
            self::getConfiguration($env),
            self::getEventManager()
        );
    }

    /**
     * @throws DBALException
     * @return Connection
     */
    protected static function getConnection()
    {
        return ConnectionFactory::getConnection();
    }

    /**
     * @return Configuration
     */
    protected static function getConfiguration($env = 'prod')
    {
        if ('prod' === $env) {
            $configuration = Setup::createXMLMetadataConfiguration(
                array(__DIR__.'/../../../resources/doctrine/orm/mapping'),
                false,
                __DIR__.'/../../../resources/doctrine/orm/proxy',
                self::getCache()
            );
        } else {
            $configuration = Setup::createAnnotationMetadataConfiguration(
                array(__DIR__.'/../../Entity'),
                true,
                __DIR__.'/../../../resources/doctrine/orm/proxy',
                self::getCache(),
                false
            );
        }

        $configuration->setProxyNamespace('Zruchna\FreePbx\Autorecaller\DoctrineProxies');

        return $configuration;
    }

    /**
     * @return EventManager
     */
    protected static function getEventManager()
    {
        return EventManagerFactory::getEventManager();
    }

    /**
     * @return Cache
     */
    protected static function getCache()
    {
        return new VoidCache();
    }
}
