<?php

namespace Zruchna\FreePbx\Autorecaller\Factory;

use Zruchna\FreePbx\Autorecaller\Clock\ClockInterface;
use Zruchna\FreePbx\Autorecaller\Clock\SystemClock;

abstract class ClockFactory
{
    /** @var ClockInterface|null */
    private static $clock = null;

    /**
     * @return ClockInterface
     */
    public static function getClock()
    {
        if (null !== self::$clock) {
            return self::$clock;
        }

        self::$clock = $clock = SystemClock::utc();

        return $clock;
    }
}
