<?php

namespace Zruchna\FreePbx\Autorecaller\Factory\Builder;

use Zruchna\FreePbx\Autorecaller\Builder\ScheduledRecallBuilder;
use Zruchna\FreePbx\Autorecaller\Clock\ClockInterface;
use Zruchna\FreePbx\Autorecaller\Factory\ClockFactory;

abstract class ScheduledRecallBuilderFactory
{
    /**
     * @return ScheduledRecallBuilder
     */
    public static function getScheduledRecallBuilder()
    {
        return new ScheduledRecallBuilder(
            self::getClock()
        );
    }

    /**
     * @return ClockInterface
     */
    protected static function getClock()
    {
        return ClockFactory::getClock();
    }
}
