<?php

namespace Zruchna\FreePbx\Autorecaller\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autorecaller\Repository\AutorecallerRepository;

/**
 * @ORM\Entity(repositoryClass=AutorecallerRepository::class)
 * @ORM\Table(name="zruchna_autorecallers")
 */
class Autorecaller
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\Column(name="name", type="string", length=80, nullable=false)
     *
     * @var string|null
     */
    private $name = null;

    /**
     * @ORM\Column(name="enabled", type="boolean", nullable=false)
     *
     * @var bool|null
     */
    private $enabled = null;

    /**
     * @ORM\Column(name="timecondition_id", type="integer", nullable=true)
     *
     * @var int|null
     */
    private $timeconditionId = null;

    /**
     * @ORM\ManyToOne(targetEntity=Recording::class)
     * @ORM\JoinColumn(name="recording_id", nullable=false)
     *
     * @var Recording|null
     */
    private $recording = null;

    /**
     * Seconds from 00:00:00 in UTC.
     *
     * @ORM\Column(name="worktime_starts_from", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $worktimeStartsFrom = null;

    /**
     * Seconds between new the workday originates.
     *
     * @ORM\Column(name="worktime_start_interval", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $worktimeStartInterval = null;

    /**
     * @ORM\OneToMany(targetEntity=AutorecallerRule::class, mappedBy="autorecaller")
     *
     * @var Collection
     */
    private $rules;

    public function __construct()
    {
        $this->rules = new ArrayCollection();
    }

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool|null $enabled
     * @return self
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getTimeconditionId()
    {
        return $this->timeconditionId;
    }

    /**
     * @param int|null $timeconditionId
     * @return self
     */
    public function setTimeconditionId($timeconditionId)
    {
        $this->timeconditionId = $timeconditionId;

        return $this;
    }

    /**
     * @return Recording|null
     */
    public function getRecording()
    {
        return $this->recording;
    }

    /**
     * @param Recording|null $recording
     * @return self
     */
    public function setRecording($recording)
    {
        $this->recording = $recording;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getWorktimeStartsFrom()
    {
        return $this->worktimeStartsFrom;
    }

    /**
     * @param int|null $worktimeStartsFrom
     * @return self
     */
    public function setWorktimeStartsFrom($worktimeStartsFrom)
    {
        $this->worktimeStartsFrom = $worktimeStartsFrom;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getWorktimeStartInterval()
    {
        return $this->worktimeStartInterval;
    }

    /**
     * @param int|null $worktimeStartInterval
     * @return Autorecaller
     */
    public function setWorktimeStartInterval($worktimeStartInterval)
    {
        $this->worktimeStartInterval = $worktimeStartInterval;

        return $this;
    }

    /**
     * @return Collection|
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * @return self
     */
    public function addRule(AutorecallerRule $rule)
    {
        if (!$this->rules->contains($rule)) {
            $this->rules->add($rule);
            $rule->setAutorecaller($this);
        }

        return $this;
    }

    /**
     * @return self
     */
    public function removeRule(AutorecallerRule $rule)
    {
        if ($this->rules->removeElement($rule)) {
            if ($this === $rule->getAutorecaller()) {
                $rule->setAutorecaller(null);
            }
        }

        return $this;
    }
}
