<?php

namespace Zruchna\FreePbx\Autorecaller\Command;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Zruchna\FreePbx\Autorecaller\Entity\ScheduledRecall;
use Zruchna\FreePbx\Autorecaller\Factory\Doctrine\EntityManagerFactory;
use Zruchna\FreePbx\Autorecaller\Factory\Repository\SimpleRepositoryFactory;
use Zruchna\FreePbx\Autorecaller\Repository\ScheduledRecallRepository;

class RegisterSuccessfulRecallCommand extends Command
{
    protected static $defaultName = 'register-successful-recall';

    /** @var EntityManagerInterface|null */
    private $entityManager = null;

    /** @var ScheduledRecallRepository|null */
    private $scheduledRecallRepository = null;

    protected function initialize(InputInterface $input, OutputInterface $output)
    {
        if (null === $this->entityManager) {
            $this->entityManager = EntityManagerFactory::getEntityManager();
        }
        if (null === $this->scheduledRecallRepository) {
            $this->scheduledRecallRepository = SimpleRepositoryFactory::getRepository(ScheduledRecall::class);
        }
    }

    protected function configure()
    {
        $this->setProcessTitle('zruchna.io · Autorecaller');

        $this->addArgument('recall-id', InputArgument::REQUIRED);

        $this->addOption('call-id', null, InputOption::VALUE_OPTIONAL);
        $this->addOption('caller-id', null, InputOption::VALUE_OPTIONAL);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $recallId = $input->getArgument('recall-id');
        $callId = $input->getOption('call-id');
        $callerId = $input->getOption('caller-id');

        $io = new SymfonyStyle($input, $output);

        if (!\is_int($recallId) && !\is_numeric($recallId)) {
            $io->error('"recall-id" argument must be an integer value.');

            return 2;
        }

        $recallId = (int) $recallId;

        $recall = $this->scheduledRecallRepository->find($recallId);
        if (null === $recall) {
            $io->warning(sprintf('Unable to find %d recall.', $recallId));

            return 1;
        }

        if (null !== $callerId && $recall->getCallerId() !== $callerId) {
            if (!$output->isQuiet()) {
                $io->warning('Provided caller ID is not same with found in recall.');
            }
        }

        if (null !== $recall->getCallId()) {
            if (!$output->isQuiet()) {
                $io->warning('This recall is already non-actual.');
            }

            return 0;
        }

        if (null !== $callId) {
            $recall->setCallId($callId);
        } else {
            // TODO: It must not be like this!
            $this->entityManager->remove($recall);
        }

        $this->entityManager->flush();

        return 0;
    }
}
