<?php

namespace Zruchna\FreePbx\Autorecaller\Command;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Zruchna\FreePbx\Autorecaller\Entity\ScheduledRecall;
use Zruchna\FreePbx\Autorecaller\Factory\Doctrine\EntityManagerFactory;
use Zruchna\FreePbx\Autorecaller\Factory\Repository\SimpleRepositoryFactory;
use Zruchna\FreePbx\Autorecaller\Repository\ScheduledRecallRepository;

class CancelRecallCommand extends Command
{
    protected static $defaultName = 'cancel-recall';

    /** @var EntityManagerInterface|null */
    private $entityManager = null;

    /** @var ScheduledRecallRepository|null */
    private $scheduledRecallRepository = null;

    protected function initialize(InputInterface $input, OutputInterface $output)
    {
        if (null === $this->entityManager) {
            $this->entityManager = EntityManagerFactory::getEntityManager();
        }
        if (null === $this->scheduledRecallRepository) {
            $this->scheduledRecallRepository = SimpleRepositoryFactory::getRepository(ScheduledRecall::class);
        }
    }

    protected function configure()
    {
        $this->setProcessTitle('zruchna.io · Autorecaller');

        $this->addArgument('caller-id', InputArgument::REQUIRED);

        $this->addOption('reason', null, InputOption::VALUE_REQUIRED, '"inbound-call-answer" or "outbound-call-answer"');
        $this->addOption('call-id', null, InputOption::VALUE_OPTIONAL);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $callerId = $input->getArgument('caller-id');
        // $reason = $input->getOption('reason');
        $callId = $input->getOption('call-id');

        $scheduledRecalls = $this->findScheduledRecallsForCallerId($callerId);

        if (null !== $callId) {
            foreach ($scheduledRecalls as $scheduledRecall) {
                $scheduledRecall->setCallId($callId);
            }
        } else {
            foreach ($scheduledRecalls as $scheduledRecall) {
                // TODO: It must not be like this!
                $this->entityManager->remove($scheduledRecall);
            }
        }

        $this->entityManager->flush();
    }

    /**
     * @param string $callerId
     * @return ScheduledRecall[]
     */
    private function findScheduledRecallsForCallerId($callerId)
    {
        return $this->scheduledRecallRepository->findByCallerId($callerId, true);
    }
}
