<?php

namespace Zruchna\FreePbx\Autoinformer\Util;

/**
 * @internal
 *
 * @author Stanislau Kviatkouski <7zete7@gmail.com>
 */
class TimezoneRegistry
{
    /**
     * @var array<string, \DateTimeZone>
     */
    private static $timezones = [];

    /**
     * @var array<string, \Exception>
     */
    private static $exceptions = [];

    /**
     * @param string $timezone
     * @return \DateTimeZone
     * @throws \Exception
     */
    public static function getTimezone($timezone)
    {
        \assert(\is_string($timezone));

        if (isset(self::$timezones[$timezone])) {
            return self::$timezones[$timezone];
        }
        if (isset(self::$exceptions[$timezone])) {
            throw self::$exceptions[$timezone];
        }

        try {
            $timezoneObject = new \DateTimeZone($timezone);
        } catch (\Exception $exception) {
            self::$exceptions[$timezone] = $exception;

            throw $exception;
        }

        self::$timezones[$timezone] = $timezoneObject;

        return $timezoneObject;
    }
}
