<?php

namespace Zruchna\FreePbx\Autoinformer\Factory\Doctrine;

use Doctrine\Common\EventManager;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Driver;
use FreePBX\Database;

/**
 * @author Stanislau Kviatkouski <7zete7@gmail.com>
 */
abstract class ConnectionFactory
{
    /** @var Connection|null */
    private static $connection = null;

    /**
     * @throws DBALException
     * @return Connection
     */
    public static function getConnection()
    {
        if (null !== self::$connection) {
            return self::$connection;
        }

        return self::$connection = new Connection(
            self::getParams(),
            self::getDriver(),
            null,
            self::getEventManager()
        );
    }

    /**
     * @return array{ pdo: \PDO }
     */
    protected static function getParams()
    {
        return array(
            'pdo' => self::getPdo(),
        );
    }

    /**
     * @return \PDO
     */
    protected static function getPdo()
    {
        $database = \FreePBX::Database();
        \assert($database instanceof Database);
        \assert($database instanceof \PDO);

        return $database;
    }

    /**
     * @return Driver
     */
    protected static function getDriver()
    {
        return new Driver\PDOMySql\Driver();
    }

    /**
     * @return EventManager
     */
    protected static function getEventManager()
    {
        return EventManagerFactory::getEventManager();
    }
}
