<?php

namespace Zruchna\FreePbx\Autoinformer\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autoinformer\Repository\IvrDetailRepository;

/**
 * @ORM\Entity(repositoryClass=IvrDetailRepository::class)
 * @ORM\Table(name="ivr_details")
 */
class IvrDetail
{
    const DIRECT_DIAL_DISABLED = 'Disabled';
    const DIRECT_DIAL_ENABLED = 'Enabled';

    const RECORDING_DEFAULT = 'default';

    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\Column(name="name", type="string", length=150, nullable=true)
     *
     * @var string|null
     */
    private $name = null;

    /**
     * @ORM\Column(name="description", type="string", length=150, nullable=true)
     *
     * @var string|null
     */
    private $description = null;

    /**
     * @ORM\Column(name="announcement", type="integer", nullable=true)
     *
     * @var int|null
     */
    private $announcementId = null;

    /**
     * @ORM\Column(name="directdial", type="string", length=50, nullable=true)
     *
     * @var string|null
     */
    private $directDial = null;

    /**
     * @ORM\Column(name="invalid_loops", type="string", length=10, nullable=true)
     *
     * @var string|null
     */
    private $invalidLoops = null;

    /**
     * @ORM\Column(name="invalid_retry_recording", type="string", length=25, nullable=true)
     *
     * @var string|null
     */
    private $invalidRetryRecording = null;

    /**
     * @ORM\Column(name="invalid_destination", type="string", length=50, nullable=true)
     *
     * @var string|null
     */
    private $invalidDestination = null;

    /**
     * @ORM\Column(name="timeout_enabled", type="string", length=50, nullable=true)
     *
     * @var string|null
     */
    private $timeoutEnabled = null;

    /**
     * @ORM\Column(name="invalid_recording", type="string", length=25, nullable=true)
     *
     * @var string|null
     */
    private $invalidRecording = null;

    /**
     * @ORM\Column(name="retvm", type="string", length=8, nullable=true)
     *
     * @var string|null
     */
    private $returnToIvrAfterVm = null;

    /**
     * @ORM\Column(name="timeout_time", type="integer", nullable=true)
     *
     * @var int|null
     */
    private $timeoutTime = null;

    /**
     * @ORM\Column(name="timeout_recording", type="string", length=25, nullable=true)
     *
     * @var string|null
     */
    private $timeoutRecording = null;

    /**
     * @ORM\Column(name="timeout_retry_recording", type="string", length=25, nullable=true)
     *
     * @var string|null
     */
    private $timeoutRetryRecording = null;

    /**
     * @ORM\Column(name="timeout_destination", type="string", length=50, nullable=true)
     *
     * @var string|null
     */
    private $timeoutDestination = null;

    /**
     * @ORM\Column(name="timeout_loops", type="string", length=10, nullable=true)
     *
     * @var string|null
     */
    private $timeoutLoops = null;

    /**
     * @ORM\Column(name="timeout_append_announce", type="boolean", nullable=false)
     *
     * @var bool
     */
    private $timeoutAppendAnnounce = true;

    /**
     * @ORM\Column(name="invalid_append_announce", type="boolean", nullable=false)
     *
     * @var bool
     */
    private $invalidAppendAnnounce = true;

    /**
     * @ORM\Column(name="timeout_ivr_ret", type="boolean", nullable=false)
     *
     * @var bool
     */
    private $timeoutIvrRet = false;

    /**
     * @ORM\Column(name="invalid_ivr_ret", type="boolean", nullable=false)
     *
     * @var bool
     */
    private $invalidIvrRet = false;

    /**
     * @ORM\Column(name="alertinfo", type="string", length=150, nullable=true)
     *
     * @var string|null
     */
    private $alertInfo = null;

    /**
     * @ORM\Column(name="rvolume", type="string", length=2, nullable=false)
     *
     * @var string
     */
    private $rVolume = '';

    /**
     * @ORM\Column(name="strict_dial_timeout", type="integer", nullable=false)
     *
     * @var int
     */
    private $strictDialTimeout = 2;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return self
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getAnnouncementId()
    {
        return $this->announcementId;
    }

    /**
     * @param int|null $announcementId
     * @return self
     */
    public function setAnnouncementId($announcementId)
    {
        $this->announcementId = $announcementId;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDirectDial()
    {
        return $this->directDial;
    }

    /**
     * @param string|null $directDial
     * @return self
     */
    public function setDirectDial($directDial)
    {
        $this->directDial = $directDial;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getInvalidLoops()
    {
        return $this->invalidLoops;
    }

    /**
     * @param string|null $invalidLoops
     * @return self
     */
    public function setInvalidLoops($invalidLoops)
    {
        $this->invalidLoops = $invalidLoops;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getInvalidRetryRecording()
    {
        return $this->invalidRetryRecording;
    }

    /**
     * @param string|null $invalidRetryRecording
     * @return self
     */
    public function setInvalidRetryRecording($invalidRetryRecording)
    {
        $this->invalidRetryRecording = $invalidRetryRecording;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getInvalidDestination()
    {
        return $this->invalidDestination;
    }

    /**
     * @param string|null $invalidDestination
     * @return self
     */
    public function setInvalidDestination($invalidDestination)
    {
        $this->invalidDestination = $invalidDestination;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTimeoutEnabled()
    {
        return $this->timeoutEnabled;
    }

    /**
     * @param string|null $timeoutEnabled
     * @return self
     */
    public function setTimeoutEnabled($timeoutEnabled)
    {
        $this->timeoutEnabled = $timeoutEnabled;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getInvalidRecording()
    {
        return $this->invalidRecording;
    }

    /**
     * @param string|null $invalidRecording
     * @return self
     */
    public function setInvalidRecording($invalidRecording)
    {
        $this->invalidRecording = $invalidRecording;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getReturnToIvrAfterVm()
    {
        return $this->returnToIvrAfterVm;
    }

    /**
     * @param string|null $returnToIvrAfterVm
     * @return self
     */
    public function setReturnToIvrAfterVm($returnToIvrAfterVm)
    {
        $this->returnToIvrAfterVm = $returnToIvrAfterVm;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getTimeoutTime()
    {
        return $this->timeoutTime;
    }

    /**
     * @param int|null $timeoutTime
     * @return self
     */
    public function setTimeoutTime($timeoutTime)
    {
        $this->timeoutTime = $timeoutTime;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTimeoutRecording()
    {
        return $this->timeoutRecording;
    }

    /**
     * @param string|null $timeoutRecording
     * @return self
     */
    public function setTimeoutRecording($timeoutRecording)
    {
        $this->timeoutRecording = $timeoutRecording;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTimeoutRetryRecording()
    {
        return $this->timeoutRetryRecording;
    }

    /**
     * @param string|null $timeoutRetryRecording
     * @return self
     */
    public function setTimeoutRetryRecording($timeoutRetryRecording)
    {
        $this->timeoutRetryRecording = $timeoutRetryRecording;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTimeoutDestination()
    {
        return $this->timeoutDestination;
    }

    /**
     * @param string|null $timeoutDestination
     * @return self
     */
    public function setTimeoutDestination($timeoutDestination)
    {
        $this->timeoutDestination = $timeoutDestination;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTimeoutLoops()
    {
        return $this->timeoutLoops;
    }

    /**
     * @param string|null $timeoutLoops
     * @return self
     */
    public function setTimeoutLoops($timeoutLoops)
    {
        $this->timeoutLoops = $timeoutLoops;

        return $this;
    }

    /**
     * @return bool
     */
    public function isTimeoutAppendAnnounce()
    {
        return $this->timeoutAppendAnnounce;
    }

    /**
     * @param bool $timeoutAppendAnnounce
     * @return self
     */
    public function setTimeoutAppendAnnounce($timeoutAppendAnnounce)
    {
        $this->timeoutAppendAnnounce = $timeoutAppendAnnounce;

        return $this;
    }

    /**
     * @return bool
     */
    public function isInvalidAppendAnnounce()
    {
        return $this->invalidAppendAnnounce;
    }

    /**
     * @param bool $invalidAppendAnnounce
     * @return self
     */
    public function setInvalidAppendAnnounce($invalidAppendAnnounce)
    {
        $this->invalidAppendAnnounce = $invalidAppendAnnounce;

        return $this;
    }

    /**
     * @return bool
     */
    public function isTimeoutIvrRet()
    {
        return $this->timeoutIvrRet;
    }

    /**
     * @param bool $timeoutIvrRet
     * @return self
     */
    public function setTimeoutIvrRet($timeoutIvrRet)
    {
        $this->timeoutIvrRet = $timeoutIvrRet;

        return $this;
    }

    /**
     * @return bool
     */
    public function isInvalidIvrRet()
    {
        return $this->invalidIvrRet;
    }

    /**
     * @param bool $invalidIvrRet
     * @return self
     */
    public function setInvalidIvrRet($invalidIvrRet)
    {
        $this->invalidIvrRet = $invalidIvrRet;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getAlertInfo()
    {
        return $this->alertInfo;
    }

    /**
     * @param string|null $alertInfo
     * @return self
     */
    public function setAlertInfo($alertInfo)
    {
        $this->alertInfo = $alertInfo;

        return $this;
    }

    /**
     * @return string
     */
    public function getRVolume()
    {
        return $this->rVolume;
    }

    /**
     * @param string $rVolume
     * @return self
     */
    public function setRVolume($rVolume)
    {
        $this->rVolume = $rVolume;

        return $this;
    }

    /**
     * @return int
     */
    public function getStrictDialTimeout()
    {
        return $this->strictDialTimeout;
    }

    /**
     * @param int $strictDialTimeout
     * @return self
     */
    public function setStrictDialTimeout($strictDialTimeout)
    {
        $this->strictDialTimeout = $strictDialTimeout;

        return $this;
    }
}
