<?php

namespace Zruchna\FreePbx\Autoinformer\Builder;

use Zruchna\FreePbx\Autoinformer\Entity\IvrDetail;
use Zruchna\FreePbx\Autoinformer\Entity\Recording;

class IvrDetailBuilder
{
    /**
     * @var IvrDetail|null
     */
    private $ivrDetail = null;

    /**
     * @return void
     */
    public function reset()
    {
        $this->ivrDetail = null;
    }

    /**
     * @param Recording $recording
     * @return self
     */
    public function announcementLike(Recording $recording)
    {
        if (null === $this->ivrDetail) {
            $this->ivrDetail = new IvrDetail();
        }

        $this->ivrDetail
            ->setAnnouncementId($recording->getId())
            ->setDirectDial(IvrDetail::DIRECT_DIAL_DISABLED)
            ->setInvalidLoops('0')
            ->setInvalidRetryRecording(IvrDetail::RECORDING_DEFAULT)
            ->setInvalidDestination('')
            ->setTimeoutEnabled(null)
            ->setInvalidRecording('')
            ->setReturnToIvrAfterVm('')
            ->setTimeoutTime(1)
            ->setTimeoutRecording('')
            ->setTimeoutRetryRecording('')
            ->setTimeoutDestination('app-blackhole,hangup,1')
            ->setTimeoutLoops('0')
            ->setTimeoutAppendAnnounce(false)
            ->setInvalidAppendAnnounce(false)
            ->setTimeoutIvrRet(false)
            ->setInvalidIvrRet(false)
            ->setAlertInfo('')
            ->setRVolume('0')
            ->setStrictDialTimeout(2)
        ;

        return $this;
    }

    /**
     * @return IvrDetail
     */
    public function getIvrDetail()
    {
        return $this->ivrDetail;
    }
}
