<?php

namespace Zruchna\FreePbx\Autoinformer\Factory;

use Symfony\Component\Console\Application;
use Symfony\Component\Console\CommandLoader\CommandLoaderInterface;
use Symfony\Component\Console\CommandLoader\FactoryCommandLoader;
use Zruchna\FreePbx\Autoinformer\Command\OriginateScheduledCallsCommand;

abstract class TinyConsoleApplicationFactory
{
    /** @var Application|null */
    private static $application = null;

    /**
     * @return Application
     */
    public static function getConsoleApplication()
    {
        if (null !== self::$application) {
            return self::$application;
        }

        self::$application = $application = new Application('zruchna-autoinformer');

        $application->setCommandLoader(self::getCommandLoader());

        return $application;
    }

    /**
     * @return CommandLoaderInterface
     */
    protected static function getCommandLoader()
    {
        return new FactoryCommandLoader(array(
            'originate-scheduled-calls' => function () {
                return new OriginateScheduledCallsCommand();
            },
        ));
    }
}
