<?php

namespace Zruchna\FreePbx\Autoinformer\Dialplan\ApplicationDecorator;

use Zruchna\FreePbx\Autoinformer\Dialplan\Application\VerboseApplication;

final class VendorCommentApplicationDecorator extends AbstractApplicationDecorator
{
    /**
     * @var int
     */
    private $autoinformerId;

    /**
     * @var string
     */
    private $message;

    /**
     * @param int $autoinformerId
     * @param string $message
     */
    public function __construct($autoinformerId, $message)
    {
        $this->autoinformerId = $autoinformerId;
        $this->message = $message;

        parent::__construct(
            VerboseApplication::createWithoutLevel(
                self::makeVendorMessage($autoinformerId, $message)
            )
        );
    }

    /**
     * @return int
     */
    public function getAutoinformerId()
    {
        return $this->autoinformerId;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param int $autoinformerId
     * @param string $message
     * @return string
     */
    private static function makeVendorMessage($autoinformerId, $message)
    {
        return sprintf('%s: %s', self::makeVendorPrefix($autoinformerId), $message);
    }

    /**
     * @param int $autoinformerId
     * @return string
     */
    private static function makeVendorPrefix($autoinformerId)
    {
        return sprintf('Zruchna - Autoinformer #%d', $autoinformerId);
    }
}
