<?php

namespace Zruchna\FreePbx\Autoinformer\Dialplan\ApplicationDecorator;

use Zruchna\FreePbx\Autoinformer\Dialplan\Application\AbstractFreePbxApplication;
use Zruchna\FreePbx\Autoinformer\Dialplan\Application\DialplanApplicationInterface;

/**
 * @template-covariant T of DialplanApplicationInterface
 */
abstract class AbstractApplicationDecorator extends AbstractFreePbxApplication implements DialplanApplicationInterface
{
    /**
     * @var DialplanApplicationInterface
     *
     * @phpstan-var T
     */
    private $internalApplication;

    /**
     * @phpstan-param T $internalApplication
     */
    public function __construct(DialplanApplicationInterface $internalApplication)
    {
        $this->internalApplication = $internalApplication;
    }

    /**
     * @return string
     */
    public function getApplication()
    {
        return $this->internalApplication->getApplication();
    }

    /**
     * @return string|null
     */
    public function getData()
    {
        return $this->internalApplication->getData();
    }

    /**
     * @return DialplanApplicationInterface
     *
     * @phpstan-return T
     */
    protected function getInternalApplication()
    {
        return $this->internalApplication;
    }
}
