<?php

namespace Zruchna\FreePbx\Autoinformer\Dialplan\Application;

final class VerboseApplication extends AbstractFreePbxApplication implements DialplanApplicationInterface
{
    /**
     * @var int|null
     */
    private $level;

    /**
     * @var string
     */
    private $message;

    /**
     * @param int|null $level
     * @param string $message
     */
    private function __construct($level, $message)
    {
        $this->level = $level;
        $this->message = $message;
    }

    /**
     * @param string $message
     * @return self
     */
    public static function createWithoutLevel($message)
    {
        return new self(null, $message);
    }

    /**
     * @param int $level
     * @param string $message
     * @return self
     */
    public static function createWithLevel($level, $message)
    {
        return new self($level, $message);
    }

    /**
     * @return int|null
     */
    public function getLevel()
    {
        return $this->level;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getApplication()
    {
        return 'Verbose';
    }

    /**
     * @return string
     */
    public function getData()
    {
        /** @var string[] $parameters */
        $parameters = array();

        if (null !== $this->level) {
            $parameters[] = sprintf('%d', $this->level);
        }

        $parameters[] = $this->message;

        return implode(',', $parameters);
    }
}
