<?php

namespace Zruchna\FreePbx\Autoinformer\Dialplan\Application;

/**
 * Hang up the calling channel.
 *
 * This application will hang up the calling channel.
 *
 * @see https://wiki.asterisk.org/wiki/display/AST/Application_Hangup
 */
final class HangupApplication extends \ext_hangup implements DialplanApplicationInterface
{
    /**
     * @var string|null
     */
    private $causeCode;

    /**
     * @param string|null $causeCode
     * If a <i>causecode</i> is given the channel's hangup cause
     * will be set to the given value.
     */
    public function __construct($causeCode = null)
    {
        $this->causeCode = $causeCode;

        parent::__construct($causeCode);
    }

    /**
     * @return string|null
     */
    public function getCauseCode()
    {
        return $this->causeCode;
    }

    /**
     * @return string
     */
    public function getApplication()
    {
        return 'Hangup';
    }

    /**
     * @return string|null
     */
    public function getData()
    {
        return $this->causeCode;
    }

    /**
     * @return string
     */
    public function output()
    {
        if (null === $this->causeCode) {
            return 'Hangup';
        }

        return sprintf('Hangup(%s)', $this->causeCode);
    }
}
