<?php

namespace Zruchna\FreePbx\Autoinformer\Factory;

use Zruchna\FreePbx\Autoinformer\Contract\Originator;
use Zruchna\FreePbx\Autoinformer\Service\CallfileOriginator;

abstract class OriginatorFactory
{
    /**
     * @return Originator
     */
    public static function getOriginator()
    {
        return self::getCallfileOriginator();
    }

    /**
     * @return CallfileOriginator
     */
    public static function getCallfileOriginator()
    {
        return new CallfileOriginator();
    }
}
