<?php

namespace Zruchna\FreePbx\Autoinformer\Factory\Dialplan;

use Doctrine\DBAL\DBALException;
use Doctrine\ORM\ORMException;
use Zruchna\FreePbx\Autoinformer\Dialplan\DialplanBuilder;
use Zruchna\FreePbx\Autoinformer\Entity\Autoinformer;
use Zruchna\FreePbx\Autoinformer\Factory\Repository\SimpleRepositoryFactory;
use Zruchna\FreePbx\Autoinformer\Repository\AutoinformerRepository;

abstract class DialplanBuilderFactory
{
    /**
     * @return DialplanBuilder
     * @throws DBALException
     * @throws ORMException
     */
    public static function getDialplanBuilder()
    {
        return new DialplanBuilder(
            self::getAutoinformerRepository()
        );
    }

    /**
     * @return AutoinformerRepository
     * @throws DBALException
     * @throws ORMException
     */
    private static function getAutoinformerRepository()
    {
        $repository = SimpleRepositoryFactory::getRepository(Autoinformer::class);
        \assert($repository instanceof AutoinformerRepository);

        return $repository;
    }
}
