<?php

namespace Zruchna\FreePbx\Autoinformer\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autoinformer\Repository\ScheduledCallRepository;

/**
 * @ORM\Entity(repositoryClass=ScheduledCallRepository::class)
 * @ORM\Table(name="zruchna_autoinformer_scheduled_calls")
 */
class ScheduledCall
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\ManyToOne(targetEntity=Autoinformer::class)
     * @ORM\JoinColumn(name="autoinformer_id", nullable=false)
     *
     * @var Autoinformer|null
     */
    private $autoinformer = null;

    /**
     * @ORM\Column(name="phone_number", type="string", length=35, nullable=false)
     *
     * @var string|null
     */
    private $phoneNumber = null;

    /**
     * @ORM\Column(name="created_at", type="datetime_immutable_utc", nullable=false)
     *
     * @var \DateTimeImmutable|null
     */
    private $createdAt = null;

    /**
     * @ORM\Column(name="scheduled_at", type="datetime_immutable_utc", nullable=true)
     *
     * @var \DateTimeImmutable|null
     */
    private $scheduledAt = null;

    /**
     * @ORM\Column(name="originated_at", type="datetime_immutable_utc", nullable=true)
     *
     * @var \DateTimeImmutable|null
     */
    private $originatedAt = null;

    /**
     * @ORM\Column(name="originate_until", type="datetime_immutable_utc", nullable=true)
     *
     * @var \DateTimeImmutable|null
     */
    private $originateUntil = null;

    /**
     * @ORM\Column(name="account_code", type="string", length=20, nullable=true)
     *
     * @var string|null
     */
    private $accountCode = null;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Autoinformer|null
     */
    public function getAutoinformer()
    {
        return $this->autoinformer;
    }

    /**
     * @param Autoinformer|null $autoinformer
     * @return self
     */
    public function setAutoinformer($autoinformer)
    {
        $this->autoinformer = $autoinformer;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * @param string|null $phoneNumber
     * @return self
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTimeImmutable|null $createdAt
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getScheduledAt()
    {
        return $this->scheduledAt;
    }

    /**
     * @param \DateTimeImmutable|null $scheduledAt
     * @return self
     */
    public function setScheduledAt($scheduledAt)
    {
        $this->scheduledAt = $scheduledAt;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getOriginatedAt()
    {
        return $this->originatedAt;
    }

    /**
     * @param \DateTimeImmutable|null $originatedAt
     * @return self
     */
    public function setOriginatedAt($originatedAt)
    {
        $this->originatedAt = $originatedAt;

        return $this;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getOriginateUntil()
    {
        return $this->originateUntil;
    }

    /**
     * @param \DateTimeImmutable|null $originateUntil
     * @return self
     */
    public function setOriginateUntil($originateUntil)
    {
        $this->originateUntil = $originateUntil;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->accountCode;
    }

    /**
     * @param string|null $accountCode
     * @return self
     */
    public function setAccountCode($accountCode)
    {
        $this->accountCode = $accountCode;

        return $this;
    }
}
