<?php

namespace Zruchna\FreePbx\Autoinformer\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zruchna\FreePbx\Autoinformer\Repository\AutoinformerRepository;

/**
 * @ORM\Entity(repositoryClass=AutoinformerRepository::class)
 * @ORM\Table(name="zruchna_autoinformers")
 */
class Autoinformer
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Column(name="id", type="integer", nullable=false)
     *
     * @var int|null
     */
    private $id = null;

    /**
     * @ORM\Column(name="name", type="string", length=80, nullable=false)
     *
     * @var string|null
     */
    private $name = null;

    /**
     * @ORM\Column(name="description", type="text", nullable=false)
     *
     * @var string|null
     */
    private $description = null;

    /**
     * @ORM\Column(name="enabled", type="boolean", nullable=false)
     *
     * @var bool|null
     */
    private $enabled = null;

    /**
     * @ORM\ManyToOne(targetEntity=IvrDetail::class)
     * @ORM\JoinColumn(name="ivr_detail_id", nullable=false)
     *
     * @var IvrDetail|null
     */
    private $ivrDetail = null;

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return self
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return self
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool|null $enabled
     * @return self
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;

        return $this;
    }

    /**
     * @return IvrDetail|null
     */
    public function getIvrDetail()
    {
        return $this->ivrDetail;
    }

    /**
     * @param IvrDetail|null $ivrDetail
     * @return self
     */
    public function setIvrDetail($ivrDetail)
    {
        $this->ivrDetail = $ivrDetail;

        return $this;
    }
}
