<?php

namespace Zruchna\FreePbx\Autoinformer\Dialplan;

use Zruchna\FreePbx\Autoinformer\Dialplan\Application\DialApplication;
use Zruchna\FreePbx\Autoinformer\Dialplan\Application\HangupApplication;
use Zruchna\FreePbx\Autoinformer\Dialplan\ApplicationDecorator\VendorCommentApplicationDecorator;
use Zruchna\FreePbx\Autoinformer\Entity\Autoinformer;
use Zruchna\FreePbx\Autoinformer\Repository\AutoinformerRepository;

class DialplanBuilder
{
    /**
     * @var AutoinformerRepository
     */
    private $autoinformerRepository;

    public function __construct(AutoinformerRepository $autoinformerRepository)
    {
        $this->autoinformerRepository = $autoinformerRepository;
    }

    /**
     * @return void
     */
    public function populateExtensions(\extensions $ext)
    {
        foreach ($this->findEnabledAutoinformers() as $autoinformer) {
            $this->addAutoinformerContext($ext, $autoinformer);
        }
    }

    /**
     * @return void
     */
    protected function addAutoinformerContext(\extensions $ext, Autoinformer $autoinformer)
    {
        if (null === $autoinformerId = $autoinformer->getId()) {
            throw new \UnexpectedValueException('Expected to autoinformer be have $id property populated, null provided');
        }

        $section = sprintf('zruchna-autoinformer-%d', $autoinformerId);

        $extension = '_[+X].';
        $ext->add($section, $extension, '', new VendorCommentApplicationDecorator($autoinformerId, 'Context started'));
        $ext->add($section, $extension, 'dial', new DialApplication('Local/${EXTEN}@from-internal', 300, 'tm'));
        $ext->add($section, $extension, 'end', new HangupApplication());

        $extension = 'h';
        $ext->add($section, $extension, '', new VendorCommentApplicationDecorator($autoinformerId, 'Context ending with "${DIALSTATUS}" dial status'));
        $ext->add($section, $extension, 'end', new HangupApplication());
    }

    /**
     * @return list<Autoinformer>
     */
    private function findEnabledAutoinformers()
    {
        return $this->autoinformerRepository->findBy(
            ['enabled' => true],
            ['id' => 'asc']
        );
    }
}
